this.name      = "fuelLeakUps"; 
this.author    = "eric walch"; 
this.copyright = " 2008 eric walch."; 
this.version   = "1.01";

this.shipSpawned = function()
{
    this.ship.switchAI("fuelLeakUpsJSAI.plist")
    this.collissionradius = 100
    this.shipName = this.ship.shipDisplayName
    delete this.shipSpawned;
}

this.shipDied = function(whom, why)
{
    if(this.ship.subEntities && this.ship.subEntities.length > 0) // ship still has subentities.
    {
        let position = 0
        let direction = new Vector() 
        for (let i=0; i<this.ship.subEntities.length; i++)
        {
            if(this.ship.subEntities[i].shipDescription == "womasilo")
            {
                position = this.ship.subEntities[i].position.x
                direction = this.ship.heading.rotateBy(0,0.25,0,0) // rotate heading toward x-axis
                system.legacy_addShipsAtPrecisely("womasilo", 1, "abs", this.ship.position.add(direction.multiply(position)))
            }
        }
        let silos = system.shipsWithRole("womasilo")
        for (let i=0; i<this.ship.subEntities.length; i++)
        {
            if(silos[i]) silos[i].setOrientation(this.ship.orientation)
        }
    }
}

this.payment = 0

this.checkLocation = function()
{
  if(system.isInterstellarSpace)
  {
    player.consoleMessage("I'll give you fuel for " + 1500 * (7 - player.fuel) + " credits.", 9);
    this.amount = 1500
  }
  else
  {
    player.consoleMessage("This entry point it unsafe and causes fuel leaks.", 9);
    this.amount = 150
    player.fuelLeakRate = 20
  }
}

this.checkDistance = function()
{
  let distance = Math.round(player.position.distanceTo(this.ship))
  if (distance < 6000)
  {
  player.consoleMessage("You are on approach, lower your speed", 9)
  this.ship.shipDisplayName = this.shipName + " with fuel"
  this.ship.reactToAIMessage("UPS_PLAYER_APPROACHING")
  }
}

this.guideIn = function()
{
    let distance = Math.round(player.position.distanceTo(this.ship)) - this.collissionradius
    let speed = Math.round(player.speed)
    if (distance > 7000)
    {
        this.ship.reactToAIMessage("UPS_PLAYER_LEAVING"); return
    }
    if (distance > 1500)
    {
        if(speed > 100) player.consoleMessage("Approaching with: " + speed + "km/h, lower your speed.", 4)
    }
    else
    {
        if(speed > 50) player.consoleMessage("Approaching with: " + speed + "km/h, lower your speed to 50 km/h.", 4)
        player.consoleMessage("You are at " + distance + " meters, come to a complete standstill within 100 meters.", 4)
    }
    if(distance < 100 && player.speed == 0)
    {
        this.ship.reactToAIMessage("UPS_PLAYER_CLOSE");
    }
}

this.checkSpeed = function()
{
    if (player.speed > 5)
    {
        player.consoleMessage("You are moving to much, lower your speed", 4)
        this.ship.reactToAIMessage("UPS_PLAYER_APPROACHING");
    }
    else
    {
        if(player.fuel < 7 && player.credits > this.amount)
        {
            player.consoleMessage("Transfering fuel..... " + Math.round(player.fuel), 3)
            player.fuel += 1
            this.payment += this.amount
            player.credits -= this.amount
        }
        else
        {
            if(this.payment == 0)
                player.commsMessage("No money no fuel. I can't help you", 6)
            else
            {
                player.commsMessage("I took " + this.payment + " credits as payment.",6)
                this.ship.reactToAIMessage("UPS_TRANSFERING_OK");
            }
        }
        this.ship.shipDisplayName = this.shipName
    }
}